import React, { useState, useEffect } from "react";
import { courseCompleted as courseCompletedSlice } from "@/newStore/features/courseCompletedSlice";
import { inProgress as inProgressSlice } from "@/newStore/features/inProgressSlice";
import { getAllCourses } from "@/newStore/features/getAllCourseSlice";
import { useSelector, useDispatch } from "react-redux";
import CourseCardItem from "../../courseCardItem/courseCardItem";
import LoaderCircle from "../../../loaderCircle/loaderCircle";

const FeaturedCourses = () => {
  const [activeTab, setActiveTab] = useState("Tab1");
  const dispatch = useDispatch();
  const courseCompleted = useSelector(
    (state) => state.courseCompleted.courseCompleted
  );
  const inProgressCourses = useSelector(
    (state) => state.inProgress.inProgressCourses
  );
  const allCourses = useSelector((state) => state.getAllCourse.courses);

  useEffect(() => {
    dispatch(courseCompletedSlice());
    dispatch(inProgressSlice());
    dispatch(getAllCourses());
  }, []);

  const buttonList = [
    {
      id: 1,
      title: "All Courses",
      onClick: () => handleTabClick("Tab1"),
      active: activeTab === "Tab1",
    },
    {
      id: 2,
      title: "Ongoing",
      onClick: () => handleTabClick("Tab2"),
      active: activeTab === "Tab2",
    },
    {
      id: 3,
      title: "Completed",
      onClick: () => handleTabClick("Tab3"),
      active: activeTab === "Tab3",
    },
  ];

  const handleTabClick = (tab) => {
    setActiveTab(tab);
  };

  return (
    <>
      <div className="flex border-b border-[#c7c7c7] my-6">
        {buttonList.map((button) => (
          <button
            key={button.id}
            onClick={button.onClick}
            className={`px-4 py-2 -mb-px transition font-bold ${
              button.active
                ? "text-black border-b-2 border-golden"
                : "text-black hover:text-black border-b-2 border-transparent"
            }`}
          >
            {button.title}
          </button>
        ))}
      </div>
      <div className="p-4">
        {activeTab === "Tab1" ? (
          !allCourses ? (
            <div className="flex justify-center items-center min-h-[50vh] min-w-full">
              <LoaderCircle />
            </div>
          ) : allCourses?.courses?.length > 0 ? (
            <div className="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
              {allCourses.courses.map((course) => (
                <CourseCardItem key={course?.id} course={course} />
              ))}
            </div>
          ) : (
            <div className="flex justify-center items-center min-h-[50vh] min-w-full">
              No Courses Available
            </div>
          )
        ) : null}
        {activeTab === "Tab2" ? (
          !inProgressCourses ? (
            <div className="flex justify-center items-center min-h-[50vh] min-w-full">
              <LoaderCircle />
            </div>
          ) : inProgressCourses?.length > 0 ? (
            <div className="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
              {inProgressCourses.map((course) => (
                <CourseCardItem key={course?.id} course={course} />
              ))}
            </div>
          ) : (
            <div className="flex justify-center items-center min-h-[50vh] min-w-full">
              No Courses Available
            </div>
          )
        ) : null}
        {activeTab === "Tab3" ? (
          !courseCompleted ? (
              <div className="flex justify-center items-center min-h-[50vh] min-w-full">
                <LoaderCircle />
              </div>
            ) : courseCompleted?.length > 0 ? (
              <div className="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                {courseCompleted.map((course) => (
                  <CourseCardItem key={course?.id} course={course} />
                ))}
              </div>
            ) : (
              <div className="flex justify-center items-center min-h-[50vh] min-w-full">
                No Courses Available
              </div>
            )
        ) : null}
      </div>
    </>
  );
};

export default FeaturedCourses;
